/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import satisfyu.candlelight.util.CopperTiers;

public class CookingPanItem
extends BlockItem {
    private final Multimap<Attribute, AttributeModifier> toolAttributes;
    private final SoundEvent panHit;
    public static final CopperTiers COOKING_PAN_TIER = CopperTiers.COPPER;

    public CookingPanItem(Block block, Item.Properties properties, SoundEvent panHit) {
        super(block, properties.m_41499_(COOKING_PAN_TIER.m_6609_()));
        float attackDamage = 2.0f + COOKING_PAN_TIER.m_6631_();
        this.panHit = panHit;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        Level world = attacker.f_19853_;
        world.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), this.panHit, SoundSource.PLAYERS, 5.0f, 5.0f);
        return true;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return COOKING_PAN_TIER.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(1, entity, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            return super.m_40576_(context);
        }
        return InteractionResult.PASS;
    }

    public int m_6473_() {
        return COOKING_PAN_TIER.m_6601_();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.toolAttributes : super.m_7167_(equipmentSlot);
    }
}

